<?php
/* ********************************************************************************
 * The content of this file is subject to the Corrensa ("License");
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is VTExperts.com
 * Portions created by VTExperts.com. are Copyright(C) VTExperts.com.
 * All Rights Reserved.
 * ****************************************************************************** */
require_once('modules/Corrensa/actions/SettingAjax.php');

class Corrensa_Uninstall_Action extends Settings_Vtiger_Index_Action {


	/**
	 * Settings_LayoutEditor_Field_Action constructor.
	 */
	public function __construct()
	{
		$this->exposeMethod('approve');
	}

	function process(Vtiger_Request $request)
	{
		$mode = $request->get('mode');
		if (!empty($mode)) {
			$this->invokeExposedMethod($mode, $request);
			return;
		}
	}

	function checkPermission(Vtiger_Request $request)
	{
		return true;
	}

	public function approve() {
		global $adb;

		// ajax disconnect first unistall
		$ajaxAction = new Corrensa_SettingAjax_Action();
		$ajaxAction -> disconnect();

		$module = Vtiger_Module::getInstance('Corrensa');

		// remove directory
		$this->delete_folder('layouts/vlayout/modules/Corrensa');
        $this->delete_folder('layouts/v7/modules/Corrensa');
		$this->delete_folder('modules/Corrensa');

		// Remove link
		$module->deleteLink('HEADERSCRIPT', 'CorrensaGlobalJS', 'layouts/vlayout/modules/Corrensa/resources/js/Corrensa.js');

		// Remove setting menu
		$adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?", array('Corrensa'));

		// drop tables
		$sql = "DROP TABLE `corrensa_settings`";

		$adb->pquery($sql,array());

		// Uninstall module
		if ($module) $module->delete();

		header("Location: index.php?module=ModuleManager&parent=Settings&view=List");
	}


    function delete_folder($tmp_path){
        if(!is_writeable($tmp_path) && is_dir($tmp_path) && isFileAccessible($tmp_path)) {
            chmod($tmp_path,0777);
        }
        $handle = opendir($tmp_path);
        while($tmp=readdir($handle)) {
            if($tmp!='..' && $tmp!='.' && $tmp!=''){
                if(is_writeable($tmp_path.DS.$tmp) && is_file($tmp_path.DS.$tmp) && isFileAccessible($tmp_path)) {
                    unlink($tmp_path.DS.$tmp);
                } elseif(!is_writeable($tmp_path.DS.$tmp) && is_file($tmp_path.DS.$tmp) && isFileAccessible($tmp_path)){
                    chmod($tmp_path.DS.$tmp,0666);
                    unlink($tmp_path.DS.$tmp);
                }

                if(is_writeable($tmp_path.DS.$tmp) && is_dir($tmp_path.DS.$tmp) && isFileAccessible($tmp_path)) {
                    $this->delete_folder($tmp_path.DS.$tmp);
                } elseif(!is_writeable($tmp_path.DS.$tmp) && is_dir($tmp_path.DS.$tmp) && isFileAccessible($tmp_path)){
                    chmod($tmp_path.DS.$tmp,0777);
                    $this->delete_folder($tmp_path.DS.$tmp);
                }
            }
        }
        closedir($handle);
        rmdir($tmp_path);
        if(!is_dir($tmp_path)) {
            return true;
        } else {
            return false;
        }
    }
}