<?php
require_once('modules/Corrensa/Corrensa.php');
require_once('modules/Corrensa/libs/CorrensaHttp.php');
require_once('modules/Corrensa/libs/utils.php');
class Corrensa_CompareConfig_View extends Vtiger_IndexAjax_View {

    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer ($request);

        global $current_user, $site_URL;
        $currentUserModel = Users_Record_Model::getInstanceById($current_user->id, 'Users');
        $vtigerData = new Corrensa_VtigerData_Model();
        $token = Corrensa_ModuleSettings_Model::get('panel_token');
        $result = CorrensaHttp::get(Corrensa::$SERVER . '/cnt/cconfig?tk='.$token);
//        $result = CorrensaHttp::post(Corrensa::$SERVER . '/cnt/cconfig', array('tk' => $token));
        $FIELDS_CONFIG=array();
        $corrensaRequiredFields=array();
        $cachingModuleModel= array();
        $vtigerModuleRequiredFields= array();

        $picklistValuesChecking=array();

        if($result['success']) {
            // Checking fields
            $fields=$result['fields'];

            foreach ($fields as $fieldDetail) {
                $fieldModule=$fieldDetail['module'];
                $fieldName=$fieldDetail['name'];
                $fieldTypeDetail = json_decode($fieldDetail['type'], 1);
                if($fieldTypeDetail['name'] == 'picklist'){
                    $corrensaPicklistValues = array_column($fieldTypeDetail['picklistValues'], 'value');
                    $vtigerPicklistValues = Vtiger_Util_Helper::getPickListValues($fieldName);
                    $picklistChecking1=array_intersect($vtigerPicklistValues, $corrensaPicklistValues);
                    $picklistChecking2=array_diff($vtigerPicklistValues, $picklistChecking1);
                    $picklistValuesChecking[$fieldModule][$fieldName]=$picklistChecking2;
                }


                if($cachingModuleModel[$fieldModule]) {
                    $moduleModel=$cachingModuleModel[$fieldModule];
                }else{
                    $moduleModel = Vtiger_Module_Model::getInstance($fieldModule);
                    $cachingModuleModel[$fieldModule]= $moduleModel;
                }
                if(!$vtigerModuleRequiredFields[$fieldModule]) {
                    $vtigerModuleRequiredFields[$fieldModule] = $this->getModuleRequiredFields($fieldModule);
                }


                if($fieldName == 'id') continue;
                if(!in_array($fieldName, $corrensaRequiredFields[$fieldModule]) && $fieldDetail['mandatory']) {
                    $corrensaRequiredFields[$fieldModule][] = $fieldName;
                }
                if(!isset($FIELDS_CONFIG[$fieldModule][$fieldName])) {
                    $fieldModel=Vtiger_Field_Model::getInstance($fieldName, $moduleModel);

                    if($fieldModel) {
                        if($fieldModel->isActiveField()) {
                            $FIELDS_CONFIG[$fieldModule][$fieldName]='Active';
                        }else{
                            $FIELDS_CONFIG[$fieldModule][$fieldName]='Inactive';
                        }
                    }else{
                        $FIELDS_CONFIG[$fieldModule][$fieldName]='Inactive';
                    }
                }
            }

            // Checking Users
            $USER_CONFIG=array();
            $corrensaUsers=array();
            foreach ($result['users'] as $cUser){
                $corrensaUsers[]=$cUser['vtiger_id'];
            }
            $vtUsers = $vtigerData->getUsers();

            foreach ($vtUsers as $vtU) {
                if(!in_array($vtU['id'], $corrensaUsers)) {
                    $USER_CONFIG[]=array('user_name' => $vtU['user_name'],'full_name' => $vtU['first_name'].' '.$vtU['last_name']);
                }
            }

        }else{
            $TEST_RESULT_ERROR=$result['msg'].". Need to login to Corrensa first.";
        }

        $viewer->assign('TEST_RESULT_ERROR', $TEST_RESULT_ERROR);
        $viewer->assign('FIELDS_CONFIG', $FIELDS_CONFIG);
        $viewer->assign('USER_CONFIG', $USER_CONFIG);
        $viewer->assign('CORRENSA_REQUIRED_FIELDS', $corrensaRequiredFields);
        $viewer->assign('VTIGER_REQUIRED_FIELDS', $vtigerModuleRequiredFields);
        $viewer->assign('VTIGER_MODULE_LIST', array_keys($FIELDS_CONFIG));
        $viewer->assign('PICKLIST_VALUES_CHECKING', $picklistValuesChecking);
        $viewer->view('CompareConfig.tpl', 'Corrensa');
    }

    public function getModuleRequiredFields($moduleName) {
        global $adb;
        $required_fields = array();
        $tabid = getTabId($moduleName);
        $sql = "select * from vtiger_field where tabid= ? and typeofdata like '%M%' and uitype not in ('53','70') and vtiger_field.presence in (0,2)";
        $result = $adb->pquery($sql, array($tabid));
        $numRows = $adb->num_rows($result);
        for ($i = 0; $i < $numRows; $i++) {
            $fieldName = $adb->query_result($result, $i, "fieldname");
            $required_fields[] = $fieldName;
        }
        return $required_fields;
    }

}